///////////////////////////////////////////////////////////////////////////////////////////

LRESULT CALLBACK TrayIconProc(HWND xWindowHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    TrayIcon_hWnd = xWindowHandle;

    while(1)
    {
        if(xMessage == WM_COMMAND)
        {

            if(LOWORD(wParam) == ID_ViewSched)
            {
                if(!IsWindowVisible(MainDialog_hWnd))
                {
                    if(IsWindowVisible(ViewScheduleDialog_hWnd))
                        SetForegroundWindow(ViewScheduleDialog_hWnd);
                    else DialogBox(MainInstance, MAKEINTRESOURCE(108), NULL, ViewScheduleDialog);
                }
            }

            if(LOWORD(wParam) == ID_Manager)
            {
                if(IsWindowVisible(MainDialog_hWnd))
                    SetForegroundWindow(MainDialog_hWnd);
                else{
                    if(!IsWindowVisible(ViewScheduleDialog_hWnd))
                        DialogBox(MainInstance, MAKEINTRESOURCE(100), NULL, MainDialog);
                }
            }

            if(LOWORD(wParam) == ID_Exit)
            {
                KillApplication();
            }

            break;
        }

        if(xMessage == WM_TIMER)
        {
            Interval();
            break;
        }

        if(xMessage == WM_CREATE)
        {
            TB_CREATED = RegisterWindowMessage("TaskbarCreated");
            SetTimer(xWindowHandle, 1, 1000, NULL);
            break;
        }

        if(xMessage == WM_SHELLNOTIFY)
        {
            if(lParam == WM_RBUTTONDOWN)
            {
                GetCursorPos(&pt);
                SetForegroundWindow(xWindowHandle);
                TrackPopupMenuEx(FileMenu, TPM_LEFTALIGN| TPM_RIGHTBUTTON, pt.x,pt.y, xWindowHandle, NULL);
                PostMessage(xWindowHandle, WM_NULL, 0, 0);
            }

            if(lParam == WM_LBUTTONDOWN)
            {
                if(IsWindowVisible(MainDialog_hWnd))
                    SetForegroundWindow(MainDialog_hWnd);
                else{
                    if(!IsWindowVisible(ViewScheduleDialog_hWnd))
                        DialogBox(MainInstance, MAKEINTRESOURCE(100), NULL, MainDialog);
                }
            }

            break;
        }

        if(xMessage == WM_DESTROY)
        {
            UnregisterClass(TitleCaption, MainInstance);
            Shell_NotifyIconA(NIM_DELETE, &Note);
            PostQuitMessage(0);
            break;
        }

        if(xMessage == WM_CLOSE)
        {
            KillTimer(xWindowHandle, 1);
            DestroyWindow(xWindowHandle);
            break;
        }

        if(xMessage == TB_CREATED)
        {
            Shell_NotifyIcon(NIM_ADD, &Note);
        }

        break;

    }

    return DefWindowProc(xWindowHandle, xMessage, wParam, lParam);
}

///////////////////////////////////////////////////////////////////////////////////////////

